<?php 
  if(!isset($_SESSION["user_id"])){ Core::redir("./");}
  $user_sesion= UserData::getById($_SESSION["user_id"]);
  // si el id  del usuario no existe.
  if($user_sesion==null){ Core::redir("./");}

  $pago = PagoData::getById(intval($_GET["id"]));
  $config = BusinessData::getById(1);
?>
<!doctype html>
<html>
  <head>
    <meta charset="utf-8">
    <base href="<?php echo APP_URL ?>">
    <title>Ticket <?php echo str_pad($pago->pago_id,6,"0",STR_PAD_LEFT) ?></title>
    <link rel="icon" type="image/png" href="res/images/favicon.png" />
    <link rel="stylesheet" href="res/bootstrap/css/bootstrap.min.css">
    <style type="text/css">
      body{
        text-transform: uppercase;
        font-size: 8pt;
        font-style: normal;
      }
      img{
        width: 75px;
        height: 75px;
      }
      hr{
        border-style: dashed ;
        margin-top: 0.5em;
        margin-bottom: 0.5em;
        border-width: 1px;
      }
    </style>
  </head>
  <body>
    <div class="content-wrapper">
      <section class="content" id="divPrintPDF"><!-- Main content -->
        <!-- empresa -->
        <div class="row">
          <div class="col-xs-12">
            <?php 
              $config = BusinessData::getById(1);
            ?>
            <div class="col-xs-3">
              <img src="res/images/Armagedon.svg">
            </div>
            <div class="col-xs-9 text-center">
              <?php echo $config->industry ?><br>
              <?php echo $config->address ?><br>
              <?php echo $config->city ?><br>
              <?php echo $config->phone ?><br>
              *** TICKET ***<br>
              <?php echo $config->name ?><br>
              NOTAS DE PAGO
            </div>
          </div> <!-- col -->
        </div> <!-- row -->
        <!-- empresa -->

        <!-- datos cliente  -->
        <div class="row">
          <hr>
          <div class="col-xs-12">
            <?php if(isset($_SESSION['data'])){ ?>
                <div class="alert alert-<?php echo $_SESSION['data']['alert']; ?> fade in">
                  <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                  <?php echo $_SESSION['data']['notice']; ?> <?php echo $_SESSION['data']['msg']; ?>
                </div>
              <?php 
                  unset($_SESSION['data']);//elimino la variable de sesion
                }
              $fechaagregado = new DateTime($pago->fecha_agregado);
            ?>
            <b>FOLIO: </b><?php echo str_pad($pago->pago_id,6,"0",STR_PAD_LEFT) ?><br>
            <b>FECHA: </b><?php echo $fechaagregado->format('d-m-Y h:i:s'); ?><br>
            <b>CLIENTE: </b><?php echo $pago->getCliente()->nombre; ?><br>
            <b>DIRECCIÓN: </b><?php echo $pago->getCliente()->direccion; ?><br>
            <b>TELEFONO: </b><?php echo $pago->getCliente()->telefono; ?><br>
          </div>
        </div>
        <!-- datos cliente  -->

        <div class="row">
          <hr>
          <div class="col-xs-12">
            <div class="col-xs-8"><b>Concepto</b></div>
            <div class="col-xs-4 text-right"><b>Importe</b></div>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12">
            <div class="col-xs-8"><?php echo $pago->getPaquete()->paquete; ?></div>
            <div class="col-xs-4 text-right">$<?php echo $pago->pago; ?></div>
          </div>
          <hr>
        </div>
        <div class="row">
          <div class="col-xs-12">
            <div class="col-xs-8 text-right"><b>TOTAL</b></div>
            <div class="col-xs-4 text-right">$ <?php echo $pago->pago; ?></div>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12">
            <div class="col-xs-8 text-right"><b>PAGA CON</b></div>
            <div class="col-xs-4 text-right">$ <?php echo $pago->efectivo; ?></div>
          </div>
        </div>
        <div class="row">
          <div class="col-xs-12">
            <div class="col-xs-8 text-right"><b>SU CAMBIO</b></div>
            <div class="col-xs-4 text-right">$ <?php echo $cambio = $pago->efectivo - $pago->pago; ?></div>
          </div>
          <hr>
        </div>

        <div class="row">
          <div class="col-xs-12">
            <div>
              <b>MES PAGADO: </b>
              <?php
                $userData = UserData::getById($_SESSION['user_id']);
                list($date)=explode(" ",$pago->fecha);
                list($Y,$m,$d)=explode("-",$date);
                $date=$d."/".$m."/".$Y;
                switch ($m) {
                  case '01':
                    echo 'Enero';
                    break;
                  case '02':
                    echo 'Febrero';
                    break;
                  case '03':
                    echo 'Marzo';
                    break;
                  case '04':
                    echo 'Abril';
                    break;
                  case '05':
                    echo 'Mayo';
                    break;
                  case '06':
                    echo 'Junio';
                    break;
                  case '07':
                    echo 'Julio';
                    break;
                  case '08':
                    echo 'Agosto';
                    break;
                  case '09':
                    echo 'Septiembre';
                    break;
                  case '10':
                    echo 'Octubre';
                    break;
                  case '11':
                    echo 'Noviembre';
                    break;
                  case '12':
                    echo 'Diciembre';
                    break;

                  default:
                    '';
                    break;
                }
              ?>
              <br>
              <b>FECHA CORTE: </b>
              <?php 
                $created_at=$pago->fecha;
                list($date)=explode(" ",$created_at);
                list($Y,$m,$d)=explode("-",$date);
                $date=$d."/".$m."/".$Y;


                $hora=$pago->hora;
                list($hora)=explode(" ",$hora);
                list($h,$i,$s)=explode(":",$hora);
                // $time=$s."/".$i."/".$H;
                $time=$h.":".$i;

                echo $date.' '.$time;
              ?>
              <br>
              <b>ATENDIO: </b><?php echo $userData->nombre ?>
              <hr>
            </div>
            <div class="text-center">
              CAMBIOS DENTRO DE LOS 7 DÍAS SIGUIENTES PRESENTANDO SU COMPROBANTE DE PAGO<br>
              *** GRACIAS POR SU PREFRENCIA ***<br>
              *** REGRESE PRONTO ***
            </div>
          </div>
        </div>
      </section>

      <section class="content">
        <div class="row">
          <hr>
          <br>
          <div class="col-xs-12 text-center">
             <a href="javascript:printPDF()" class="btn btn-info btn-lg">
               <span class="glyphicon glyphicon-print"></span> PDF
             </a>
          </div>
        </div>
      </section>
    </div>
  </body>
  <script src="res/dist/js/es6-promise.auto.min.js"></script>
  <script src="res/dist/js/jspdf.min.js"></script>
  <script src="res/dist/js/html2canvas.min.js"></script>
  <script src="res/dist/js/html2pdf.bundle.min.js"></script>
  <script>
    function printPDF(){
    var element = document.getElementById('divPrintPDF');
      var opt = {
        margin:       2,
        filename: '<?php echo str_pad($pago->pago_id,6,"0",STR_PAD_LEFT) ?>.pdf',
        image:        { type: 'jpeg', quality: 0.98 },
        html2canvas:  { scale: 2 },
        jsPDF:        { unit: 'mm', format: [75,140], orientation: 'portrait' }
      };

      // New Promise-based usage:
      html2pdf().set(opt).from(element).save();

      // Old monolithic-style usage:
      //html2pdf(element, opt);
    }
  </script>
</html>